package com.hero.ui.dialog;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.ui.widgets.LevelTF;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class AppPrefsDialog extends JDialog {

	private class SourceCheckBox extends JCheckBox {
		private static final long serialVersionUID = -6843140849309040619L;

		private String source;

		public SourceCheckBox(String label) {
			super(label);
			source = label;
			setSelected(HeroDesigner.getInstance().getPrefs().getSources()
					.contains(source));
			addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (isSelected()) {
						if (HeroDesigner.getInstance().getPrefs().getSources()
								.contains(source)) {
							return;
						}
						HeroDesigner.getInstance().getPrefs().getSources().add(
								source);
					} else {
						HeroDesigner.getInstance().getPrefs().getSources()
								.remove(source);
					}
				}
			});
		}
	}

	private static final long serialVersionUID = 806993432175986846L;

	private JCheckBox restoreWindowCB;

	private JCheckBox rememberDialogCB;

	private JCheckBox loadCharactersCB;

	private JCheckBox loadPrefabsCB;

	private JCheckBox useWindowDecorationsCB;

	private JLabel tabPlacementLbl;

	private JComboBox tabPlacementCombo;

	private JLabel numberDigitsLbl;

	private LevelTF numberDigitsTF;

	private JCheckBox modifierIntelligenceCB;

	private JCheckBox checkModsDuringEditCB;

	private JCheckBox removeIllegalModsCB;

	private JPanel modifierIntelligencePanel;

	private JLabel templateDirLbl;

	private JTextField templateDirTF;

	private JButton templateBrowseBtn;

	private JLabel browserPathLbl;

	private JTextField browserPathTF;

	private JButton browserPathBrowseBtn;

	private JLabel defaultRulesDirLbl;

	private JTextField defaultRulesDirTF;

	private JButton defaultRulesDirBrowseBtn;

	private JLabel defaultExportDirLbl;

	private JTextField defaultExportDirTF;

	private JButton defaultExportDirBrowseBtn;

	private ExportTemplateDialog formatDialog;

	private JLabel defaultAIExportLbl;

	private JTextField defaultAIExportTF;

	private JButton defaultAIExportBrowseBtn;

	private JLabel defaultAutomatonExportLbl;

	private JTextField defaultAutomatonExportTF;

	private JButton defaultAutomatonExportBrowseBtn;

	private JLabel defaultBaseExportLbl;

	private JTextField defaultBaseExportTF;

	private JButton defaultBaseExportBrowseBtn;

	private JLabel defaultComputerExportLbl;

	private JTextField defaultComputerExportTF;

	private JButton defaultComputerExportBrowseBtn;

	private JLabel defaultHeroicExportLbl;

	private JTextField defaultHeroicExportTF;

	private JButton defaultHeroicExportBrowseBtn;

	private JLabel defaultNormalExportLbl;

	private JTextField defaultNormalExportTF;

	private JButton defaultNormalExportBrowseBtn;

	private JLabel defaultSuperheroicExportLbl;

	private JTextField defaultSuperheroicExportTF;

	private JButton defaultSuperheroicExportBrowseBtn;

	private JLabel defaultVehicleExportLbl;

	private JTextField defaultVehicleExportTF;

	private JButton defaultVehicleExportBrowseBtn;

	private JPanel generalPanel;

	private JPanel systemPanel;

	private JPanel displayPanel;

	private JCheckBox metricCB;

	private JCheckBox displayActivePointsCB;

	private JCheckBox useAbbreviationsCB;

	private JCheckBox showPopupDefinitionsCB;

	private JCheckBox useQuickAssignCB;

	private JCheckBox confirmDeleteCB;

	private JComboBox refreshTemplateOnRestoreCB;

	private JLabel refreshTemplateOnRestoreLbl;

	private JComboBox refreshRulesOnRestoreCB;

	private JLabel refreshRulesOnRestoreLbl;

	private JCheckBox warnOnMultipleCB;

	private JCheckBox useWGCB;
	
	private JCheckBox flagForcedModifiersCB;

	private JCheckBox showCommonLimitationsCB;

	private JPanel templatePanel;

	private JTabbedPane tabPane;

	private JButton doneBtn;

	private JCheckBox showPowersPrefabsOnEquipmentCB;

	private JCheckBox showEquipmentPrefabsOnPowersCB;

	private JCheckBox promptForImageExportCB;

	private JSlider memorySlider;
	private JLabel memoryLbl;

	public AppPrefsDialog() {
		super(HeroDesigner.getAppFrame(), "Preferences", true);
		HeroDesigner.getInstance().getPrefs().setSources(
				HeroDesigner.getInstance().getPrefs().getSources());
		initWidgets();
		initListeners();
		layoutComponent();
		pack();
		this.setSize(640, getPreferredSize().height);
		setLocationRelativeTo(HeroDesigner.getAppFrame());
	}

	private void initListeners() {
		promptForImageExportCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setPromptToExportImage(
						promptForImageExportCB.isSelected());
			}
		});
		showPowersPrefabsOnEquipmentCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs()
						.setShowPowersPrefabsOnEquipment(
								showPowersPrefabsOnEquipmentCB.isSelected());
			}
		});
		showEquipmentPrefabsOnPowersCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs()
						.setShowEquipmentPrefabsOnPowers(
								showEquipmentPrefabsOnPowersCB.isSelected());
			}
		});
		tabPlacementCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				HeroDesigner.getInstance().getPrefs().setTabPosition(
						tabPlacementCombo.getSelectedIndex() + 1);
				tabPane
						.setTabPlacement(tabPlacementCombo.getSelectedIndex() + 1);
			}
		});
		confirmDeleteCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setConfirmDelete(
						confirmDeleteCB.isSelected());
			}
		});
		warnOnMultipleCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setWarnOnMultiple(
						warnOnMultipleCB.isSelected());
			}
		});
		useQuickAssignCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setUseQuickAssign(
						useQuickAssignCB.isSelected());
			}
		});
		useWGCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setUseWG(
						useWGCB.isSelected());
			}
		});
		flagForcedModifiersCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setFlagForcedModifiers(
						flagForcedModifiersCB.isSelected());
			}
		});
		useAbbreviationsCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setUseAbbreviations(
						useAbbreviationsCB.isSelected());
			}
		});
		showPopupDefinitionsCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setShowPopupDefinitions(
						showPopupDefinitionsCB.isSelected());
			}
		});
		metricCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setMetric(
						metricCB.isSelected());
			}
		});
		displayActivePointsCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setDisplayActivePoints(
						displayActivePointsCB.isSelected());
			}
		});
		showCommonLimitationsCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setShowCommonLimitations(
						showCommonLimitationsCB.isSelected());
			}
		});
		modifierIntelligenceCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs()
						.setModifierIntelligenceOn(
								modifierIntelligenceCB.isSelected());
				checkModsDuringEditCB.setEnabled(modifierIntelligenceCB
						.isSelected());
				removeIllegalModsCB.setEnabled(modifierIntelligenceCB
						.isSelected()
						&& checkModsDuringEditCB.isSelected());
			}
		});
		checkModsDuringEditCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setCheckModsDuringEdit(
						checkModsDuringEditCB.isSelected());
				removeIllegalModsCB.setEnabled(modifierIntelligenceCB
						.isSelected()
						&& checkModsDuringEditCB.isSelected());
			}
		});
		removeIllegalModsCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setRemoveIllegalMods(
						removeIllegalModsCB.isSelected());
			}
		});
		restoreWindowCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setRestoreWindow(
						restoreWindowCB.isSelected());
			}
		});
		useWindowDecorationsCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				File launcher = new File("HeroDesigner.lax");
				if (launcher.exists()) {
					try {
						FileInputStream fis = new FileInputStream(launcher);
						byte[] data = new byte[(int) launcher.length()];
						fis.read(data);
						String fileContents = new String(data);
						fis.close();
						if (fileContents.indexOf("lax.command.line.args") > 0) {
							String part1 = fileContents.substring(0,
									fileContents
											.indexOf("lax.command.line.args"));
							String part2 = fileContents.substring(fileContents
									.indexOf("\n", fileContents
											.indexOf("lax.command.line.args")),
									fileContents.length());
							String newContents = part1
									+ "lax.command.line.args=$CMD_LINE_ARGUMENTS$";
							if (useWindowDecorationsCB.isSelected()) {
								newContents += "\n";
							} else {
								newContents += " noDecorations\n";
							}
							newContents += part2;
							RandomAccessFile raf = new RandomAccessFile(
									"HeroDesigner.lax", "rw");
							raf.writeBytes(newContents);
							raf.setLength(raf.getFilePointer());
							raf.close();
							JOptionPane
									.showMessageDialog(
											AppPrefsDialog.this,
											"You must restart for this change to take effect.",
											"Restart Needed",
											JOptionPane.INFORMATION_MESSAGE);
						}
					} catch (Exception exp) {
						exp.printStackTrace(System.out);
					}
				}
			}
		});
		rememberDialogCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs()
						.setRememberDialogPosition(
								rememberDialogCB.isSelected());
			}
		});
		loadCharactersCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setLoadCharacters(
						loadCharactersCB.isSelected());
			}
		});
		loadPrefabsCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				HeroDesigner.getInstance().getPrefs().setLoadPrefabs(
						loadPrefabsCB.isSelected());
			}
		});
		templateBrowseBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser chooser = new JFileChooser();
				chooser.setApproveButtonText("Select");
				chooser.setDialogTitle("Select Character Template Directory");
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				chooser.setMultiSelectionEnabled(false);
				chooser.setAcceptAllFileFilterUsed(false);
				chooser.setCurrentDirectory(new File(HeroDesigner.getInstance()
						.getPrefs().getTemplateDir()));
				chooser.setSelectedFile(new File(HeroDesigner.getInstance()
						.getPrefs().getTemplateDir()));
				int ret = chooser.showDialog(AppPrefsDialog.this, "Select");
				if (ret == JFileChooser.CANCEL_OPTION) {
					return;
				} else if (ret == JFileChooser.APPROVE_OPTION) {
					HeroDesigner.getInstance().getPrefs().setTemplateDir(
							chooser.getSelectedFile().getAbsolutePath());
					templateDirTF.setText(chooser.getSelectedFile()
							.getAbsolutePath());
				}
			}
		});
		browserPathTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				HeroDesigner.getInstance().getPrefs().setBrowserExecutablePath(
						browserPathTF.getText());
			}

			public void insertUpdate(DocumentEvent e) {
				HeroDesigner.getInstance().getPrefs().setBrowserExecutablePath(
						browserPathTF.getText());
			}

			public void removeUpdate(DocumentEvent e) {
				HeroDesigner.getInstance().getPrefs().setBrowserExecutablePath(
						browserPathTF.getText());
			}
		});
		browserPathBrowseBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser chooser = new JFileChooser();
				chooser.setApproveButtonText("Select");
				chooser.setDialogTitle("Select Browser Executable");
				chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				chooser.setMultiSelectionEnabled(false);
				if (HeroDesigner.getInstance().getPrefs()
						.getBrowserExecutablePath() != null) {
					chooser.setSelectedFile(new File(HeroDesigner.getInstance()
							.getPrefs().getBrowserExecutablePath()));
				}
				int ret = chooser.showDialog(AppPrefsDialog.this, "Select");
				if (ret == JFileChooser.CANCEL_OPTION) {
					return;
				} else if (ret == JFileChooser.APPROVE_OPTION) {
					HeroDesigner
							.getInstance()
							.getPrefs()
							.setBrowserExecutablePath(
									chooser.getSelectedFile().getAbsolutePath());
					browserPathTF.setText(chooser.getSelectedFile()
							.getAbsolutePath());
				}
			}
		});
		defaultRulesDirBrowseBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser chooser = new JFileChooser();
				chooser.setApproveButtonText("Select");
				chooser
						.setDialogTitle("Select Default Campaign Rules Directory");
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				chooser.setMultiSelectionEnabled(false);
				chooser.setAcceptAllFileFilterUsed(false);
				chooser.setCurrentDirectory(new File(HeroDesigner.getInstance()
						.getPrefs().getDefaultRulesDir()));
				chooser.setSelectedFile(new File(HeroDesigner.getInstance()
						.getPrefs().getDefaultRulesDir()));
				int ret = chooser.showDialog(AppPrefsDialog.this, "Select");
				if (ret == JFileChooser.CANCEL_OPTION) {
					return;
				} else if (ret == JFileChooser.APPROVE_OPTION) {
					HeroDesigner.getInstance().getPrefs().setDefaultRulesDir(
							chooser.getSelectedFile().getAbsolutePath());
					defaultRulesDirTF.setText(chooser.getSelectedFile()
							.getAbsolutePath());
				}
			}
		});
		defaultExportDirBrowseBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser chooser = new JFileChooser();
				chooser.setApproveButtonText("Select");
				chooser
						.setDialogTitle("Select Default Export Template Directory");
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				chooser.setMultiSelectionEnabled(false);
				chooser.setAcceptAllFileFilterUsed(false);
				chooser.setCurrentDirectory(new File(HeroDesigner.getInstance()
						.getPrefs().getDefaultExportDir()));
				chooser.setSelectedFile(new File(HeroDesigner.getInstance()
						.getPrefs().getDefaultExportDir()));
				int ret = chooser.showDialog(AppPrefsDialog.this, "Select");
				if (ret == JFileChooser.CANCEL_OPTION) {
					return;
				} else if (ret == JFileChooser.APPROVE_OPTION) {
					HeroDesigner.getInstance().getPrefs().setDefaultExportDir(
							chooser.getSelectedFile().getAbsolutePath());
					defaultExportDirTF.setText(chooser.getSelectedFile()
							.getAbsolutePath());
				}
			}
		});

		defaultAIExportBrowseBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (formatDialog == null) {
					formatDialog = new ExportTemplateDialog();
				}
				formatDialog.setDialogTitle("Select Default AI Export Format");
				formatDialog.showOpenDialog(AppPrefsDialog.this);
				if (formatDialog.canceled()) {
					return;
				} else {
					String path = formatDialog.getSelectedPath();
					if ((path != null) && (path.trim().length() > 0)) {
						HeroDesigner.getInstance().getPrefs()
								.setDefaultAIFormatPath(path);
						defaultAIExportTF.setText(path);
					}
				}
			}
		});
		defaultAutomatonExportBrowseBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (formatDialog == null) {
					formatDialog = new ExportTemplateDialog();
				}
				formatDialog
						.setDialogTitle("Select Default Automaton Export Format");
				formatDialog.showOpenDialog(AppPrefsDialog.this);
				if (formatDialog.canceled()) {
					return;
				} else {
					String path = formatDialog.getSelectedPath();
					if ((path != null) && (path.trim().length() > 0)) {
						HeroDesigner.getInstance().getPrefs()
								.setDefaultAutomatonFormatPath(path);
						defaultAutomatonExportTF.setText(path);
					}
				}
			}
		});
		defaultBaseExportBrowseBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (formatDialog == null) {
					formatDialog = new ExportTemplateDialog();
				}
				formatDialog
						.setDialogTitle("Select Default Base Export Format");
				formatDialog.showOpenDialog(AppPrefsDialog.this);
				if (formatDialog.canceled()) {
					return;
				} else {
					String path = formatDialog.getSelectedPath();
					if ((path != null) && (path.trim().length() > 0)) {
						HeroDesigner.getInstance().getPrefs()
								.setDefaultBaseFormatPath(path);
						defaultBaseExportTF.setText(path);
					}
				}
			}
		});
		defaultComputerExportBrowseBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (formatDialog == null) {
					formatDialog = new ExportTemplateDialog();
				}
				formatDialog
						.setDialogTitle("Select Default Computer Export Format");
				formatDialog.showOpenDialog(AppPrefsDialog.this);
				if (formatDialog.canceled()) {
					return;
				} else {
					String path = formatDialog.getSelectedPath();
					if ((path != null) && (path.trim().length() > 0)) {
						HeroDesigner.getInstance().getPrefs()
								.setDefaultComputerFormatPath(path);
						defaultComputerExportTF.setText(path);
					}
				}
			}
		});
		defaultHeroicExportBrowseBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (formatDialog == null) {
					formatDialog = new ExportTemplateDialog();
				}
				formatDialog
						.setDialogTitle("Select Default Heroic Export Format");
				formatDialog.showOpenDialog(AppPrefsDialog.this);
				if (formatDialog.canceled()) {
					return;
				} else {
					String path = formatDialog.getSelectedPath();
					if ((path != null) && (path.trim().length() > 0)) {
						HeroDesigner.getInstance().getPrefs()
								.setDefaultHeroicFormatPath(path);
						defaultHeroicExportTF.setText(path);
					}
				}
			}
		});
		defaultNormalExportBrowseBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (formatDialog == null) {
					formatDialog = new ExportTemplateDialog();
				}
				formatDialog
						.setDialogTitle("Select Default Normal Export Format");
				formatDialog.showOpenDialog(AppPrefsDialog.this);
				if (formatDialog.canceled()) {
					return;
				} else {
					String path = formatDialog.getSelectedPath();
					if ((path != null) && (path.trim().length() > 0)) {
						HeroDesigner.getInstance().getPrefs()
								.setDefaultNormalFormatPath(path);
						defaultNormalExportTF.setText(path);
					}
				}
			}
		});
		defaultSuperheroicExportBrowseBtn
				.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						if (formatDialog == null) {
							formatDialog = new ExportTemplateDialog();
						}
						formatDialog
								.setDialogTitle("Select Default Superheroic Export Format");
						formatDialog.showOpenDialog(AppPrefsDialog.this);
						if (formatDialog.canceled()) {
							return;
						} else {
							String path = formatDialog.getSelectedPath();
							if ((path != null) && (path.trim().length() > 0)) {
								HeroDesigner.getInstance().getPrefs()
										.setDefaultSuperheroicFormatPath(path);
								defaultSuperheroicExportTF.setText(path);
							}
						}
					}
				});
		defaultVehicleExportBrowseBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (formatDialog == null) {
					formatDialog = new ExportTemplateDialog();
				}
				formatDialog
						.setDialogTitle("Select Default Vehicle Export Format");
				formatDialog.showOpenDialog(AppPrefsDialog.this);
				if (formatDialog.canceled()) {
					return;
				} else {
					String path = formatDialog.getSelectedPath();
					if ((path != null) && (path.trim().length() > 0)) {
						HeroDesigner.getInstance().getPrefs()
								.setDefaultVehicleFormatPath(path);
						defaultVehicleExportTF.setText(path);
					}
				}
			}
		});

		doneBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setVisible(false);
				dispose();
			}
		});
		numberDigitsTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						HeroDesigner.getInstance().getPrefs()
								.setNumberDigitsForRounding(
										numberDigitsTF.getCurrent());
					}
				});
		refreshTemplateOnRestoreCB.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				HeroDesigner
						.getInstance()
						.getPrefs()
						.setRefreshTemplateOnRestore(
								refreshTemplateOnRestoreCB.getSelectedIndex() + 1);
			}
		});
		refreshRulesOnRestoreCB.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				HeroDesigner.getInstance().getPrefs().setRefreshRulesOnRestore(
						refreshRulesOnRestoreCB.getSelectedIndex() + 1);
			}
		});
		memorySlider.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				HeroDesigner.getInstance().getPrefs().setMaximumHeapSize(
						memorySlider.getValue());
				if (!memorySlider.getValueIsAdjusting()) {
					JOptionPane
							.showMessageDialog(
									AppPrefsDialog.this,
									"Please restart HERODesigner for these changes to take effect.",
									"Restart HD", JOptionPane.WARNING_MESSAGE);
				}
			}
		});
	}

	private void initWidgets() {
		memorySlider = new JSlider(64, 512);
		memorySlider.setMajorTickSpacing(64);
		memorySlider.setMinorTickSpacing(16);
		memorySlider.setOrientation(SwingConstants.HORIZONTAL);
		memorySlider.setPaintLabels(true);
		memorySlider.setPaintTicks(true);
		memorySlider.setSnapToTicks(true);
		Hashtable vals = new Hashtable<Integer, JLabel>();
		vals.put(64, new JLabel("64MB"));
		vals.put(128, new JLabel("128MB"));
		vals.put(192, new JLabel("192MB"));
		vals.put(256, new JLabel("256MB"));
		vals.put(320, new JLabel("320MB"));
		vals.put(384, new JLabel("384MB"));
		vals.put(448, new JLabel("448MB"));
		vals.put(512, new JLabel("512MB"));
		memorySlider.setLabelTable(vals);
		memorySlider.setValue(HeroDesigner.getInstance().getPrefs()
				.getMaximumHeapSize());
		memorySlider
				.setToolTipText("<html>This is an advanced setting and should only be changed by experienced users.<br />The default value of 64MB should suffice for normal operations of HERODesigner.</html>");
		memoryLbl = new JLabel(
				"Maximum memory for HERO Designer process (MB) [ADVANCED USERS ONLY -- 64MB strongly recommended]:");
		promptForImageExportCB = new JCheckBox(
				"Prompt to export image file when exporting character");
		promptForImageExportCB.setSelected(HeroDesigner.getInstance()
				.getPrefs().getPromptToExportImage());

		tabPane = new JTabbedPane();
		tabPane.setTabPlacement(HeroDesigner.getInstance().getPrefs()
				.getTabPosition());

		tabPlacementLbl = new JLabel("Tab Placement");
		tabPlacementCombo = new JComboBox();
		tabPlacementCombo.addItem("Top");
		tabPlacementCombo.addItem("Left");
		tabPlacementCombo.addItem("Bottom");
		tabPlacementCombo.addItem("Right");
		tabPlacementCombo.setSelectedIndex(HeroDesigner.getInstance()
				.getPrefs().getTabPosition() - 1);

		useWindowDecorationsCB = new JCheckBox(
				"Use Java window decorations (requires restart)");
		useWindowDecorationsCB.setSelected(JFrame
				.isDefaultLookAndFeelDecorated());
		restoreWindowCB = new JCheckBox("Restore window position on startup");
		restoreWindowCB.setSelected(HeroDesigner.getInstance().getPrefs()
				.isRestoreWindow());
		rememberDialogCB = new JCheckBox("Remember dialog position and size");
		rememberDialogCB.setSelected(HeroDesigner.getInstance().getPrefs()
				.isRememberDialogPosition());
		loadCharactersCB = new JCheckBox("Load characters on startup");
		loadCharactersCB.setSelected(HeroDesigner.getInstance().getPrefs()
				.isLoadCharacters());
		loadPrefabsCB = new JCheckBox("Load prefabs on startup");
		loadPrefabsCB.setSelected(HeroDesigner.getInstance().getPrefs()
				.isLoadPrefabs());
		metricCB = new JCheckBox(
				"Use metric units of measurement for character Height and Weight");
		metricCB.setSelected(HeroDesigner.getInstance().getPrefs().isMetric());
		displayActivePointsCB = new JCheckBox(
				"Display Active Points on abilities (by default)");
		displayActivePointsCB.setSelected(HeroDesigner.getInstance().getPrefs()
				.displayActivePoints());

		showCommonLimitationsCB = new JCheckBox(
				"Show Common Limitations in slots on Lists/Frameworks");
		showCommonLimitationsCB.setSelected(HeroDesigner.getInstance()
				.getPrefs().showCommonLimitations());

		useAbbreviationsCB = new JCheckBox(
				"Use Abbreviations (where available)");
		useAbbreviationsCB.setSelected(HeroDesigner.getInstance().getPrefs()
				.useAbbreviations());

		showPopupDefinitionsCB = new JCheckBox(
				"Show Popup definitions in selection lists");
		showPopupDefinitionsCB.setSelected(HeroDesigner.getInstance()
				.getPrefs().showPopupDefinitions());

		showPowersPrefabsOnEquipmentCB = new JCheckBox(
				"Show Powers Prefabs on the Equipment Tab");
		showPowersPrefabsOnEquipmentCB.setSelected(HeroDesigner.getInstance()
				.getPrefs().getShowPowersPrefabsOnEquipment());

		showEquipmentPrefabsOnPowersCB = new JCheckBox(
				"Show Equipment Prefabs on the Powers Tab");
		showEquipmentPrefabsOnPowersCB.setSelected(HeroDesigner.getInstance()
				.getPrefs().getShowEquipmentPrefabsOnPowers());

		useQuickAssignCB = new JCheckBox(
				"Use \"Quick Assign\" on abilities (where available)");
		useQuickAssignCB.setSelected(HeroDesigner.getInstance().getPrefs()
				.useQuickAssign());

		confirmDeleteCB = new JCheckBox("Confirm deletions (recommended)");
		confirmDeleteCB.setSelected(HeroDesigner.getInstance().getPrefs()
				.confirmDelete());

		warnOnMultipleCB = new JCheckBox("Warn on duplicate purchases");
		warnOnMultipleCB.setSelected(HeroDesigner.getInstance().getPrefs()
				.warnOnMultiple());

		useWGCB = new JCheckBox("Use strict Writers' Guidelines compliance");
		useWGCB.setSelected(HeroDesigner.getInstance().getPrefs().useWG());
		
		flagForcedModifiersCB = new JCheckBox("Flag Forced Modifiers");
		flagForcedModifiersCB.setSelected(HeroDesigner.getInstance().getPrefs().flagForcedModifiers());

		modifierIntelligenceCB = new JCheckBox(
				"Use 'Modifier Intelligence' (strongly recommended)");
		modifierIntelligenceCB.setSelected(HeroDesigner.getInstance()
				.getPrefs().isModifierIntelligenceOn());

		checkModsDuringEditCB = new JCheckBox(
				"Check Modifiers during ability edit (recommended)");
		checkModsDuringEditCB.setSelected(HeroDesigner.getInstance().getPrefs()
				.checkModsDuringEdit());
		checkModsDuringEditCB.setEnabled(HeroDesigner.getInstance().getPrefs()
				.isModifierIntelligenceOn());

		removeIllegalModsCB = new JCheckBox(
				"Remove Modifiers which fail validity check (recommended)");
		removeIllegalModsCB.setSelected(HeroDesigner.getInstance().getPrefs()
				.removeIllegalMods());
		removeIllegalModsCB.setEnabled(HeroDesigner.getInstance().getPrefs()
				.checkModsDuringEdit());

		modifierIntelligencePanel = new JPanel(new GridBagLayout());

		refreshTemplateOnRestoreLbl = new JLabel(
				"Refresh character template from file during load?");
		refreshRulesOnRestoreLbl = new JLabel(
				"Refresh campaign rules from file during load?");
		ArrayList<String> l = new ArrayList<String>();
		l.add("Always");
		l.add("Prompt");
		l.add("Never");
		refreshTemplateOnRestoreCB = new JComboBox(l.toArray());
		refreshTemplateOnRestoreCB.setSelectedIndex(HeroDesigner.getInstance()
				.getPrefs().getRefreshTemplateOnRestore() - 1);
		refreshRulesOnRestoreCB = new JComboBox(l.toArray());
		refreshRulesOnRestoreCB.setSelectedIndex(HeroDesigner.getInstance()
				.getPrefs().getRefreshRulesOnRestore() - 1);

		numberDigitsLbl = new JLabel("Number of decimal places for rounding:");
		numberDigitsTF = new LevelTF(HeroDesigner.getInstance().getPrefs()
				.getNumberDigitsForRounding(), 10, 0);
		templateDirLbl = new JLabel("Character template directory:");
		templateDirTF = new JTextField(HeroDesigner.getInstance().getPrefs()
				.getTemplateDir());
		templateDirTF.setEnabled(false);
		templateBrowseBtn = new JButton("Browse...");

		browserPathLbl = new JLabel("Browser executable (override default):");
		browserPathTF = new JTextField(HeroDesigner.getInstance().getPrefs()
				.getBrowserExecutablePath());
		browserPathTF.setEnabled(true);
		browserPathBrowseBtn = new JButton("Browse...");

		defaultRulesDirLbl = new JLabel("Default Campaign Rules directory:");
		defaultRulesDirTF = new JTextField(HeroDesigner.getInstance()
				.getPrefs().getDefaultRulesDir());
		defaultRulesDirTF.setEnabled(false);
		defaultRulesDirBrowseBtn = new JButton("Browse...");
		defaultExportDirLbl = new JLabel("Default Export Template directory:");
		defaultExportDirTF = new JTextField(HeroDesigner.getInstance()
				.getPrefs().getDefaultExportDir());
		defaultExportDirTF.setEnabled(false);
		defaultExportDirBrowseBtn = new JButton("Browse...");

		defaultAIExportLbl = new JLabel("Default AI Export Format:");
		defaultAIExportTF = new JTextField(HeroDesigner.getInstance()
				.getPrefs().getDefaultAIFormatPath() != null ? HeroDesigner
				.getInstance().getPrefs().getDefaultAIFormatPath() : "");
		defaultAIExportTF.setEnabled(false);
		defaultAIExportBrowseBtn = new JButton("Browse...");

		defaultAutomatonExportLbl = new JLabel(
				"Default Automaton Export Format:");
		defaultAutomatonExportTF = new JTextField(
				HeroDesigner.getInstance().getPrefs()
						.getDefaultAutomatonFormatPath() != null ? HeroDesigner
						.getInstance().getPrefs()
						.getDefaultAutomatonFormatPath() : "");
		defaultAutomatonExportTF.setEnabled(false);
		defaultAutomatonExportBrowseBtn = new JButton("Browse...");

		defaultBaseExportLbl = new JLabel("Default Base Export Format:");
		defaultBaseExportTF = new JTextField(HeroDesigner.getInstance()
				.getPrefs().getDefaultBaseFormatPath() != null ? HeroDesigner
				.getInstance().getPrefs().getDefaultBaseFormatPath() : "");
		defaultBaseExportTF.setEnabled(false);
		defaultBaseExportBrowseBtn = new JButton("Browse...");

		defaultComputerExportLbl = new JLabel("Default Computer Export Format:");
		defaultComputerExportTF = new JTextField(
				HeroDesigner.getInstance().getPrefs()
						.getDefaultComputerFormatPath() != null ? HeroDesigner
						.getInstance().getPrefs()
						.getDefaultComputerFormatPath() : "");
		defaultComputerExportTF.setEnabled(false);
		defaultComputerExportBrowseBtn = new JButton("Browse...");

		defaultHeroicExportLbl = new JLabel("Default Heroic Export Format:");
		defaultHeroicExportTF = new JTextField(HeroDesigner.getInstance()
				.getPrefs().getDefaultHeroicFormatPath() != null ? HeroDesigner
				.getInstance().getPrefs().getDefaultHeroicFormatPath() : "");
		defaultHeroicExportTF.setEnabled(false);
		defaultHeroicExportBrowseBtn = new JButton("Browse...");

		defaultNormalExportLbl = new JLabel("Default Normal Export Format:");
		defaultNormalExportTF = new JTextField(HeroDesigner.getInstance()
				.getPrefs().getDefaultNormalFormatPath() != null ? HeroDesigner
				.getInstance().getPrefs().getDefaultNormalFormatPath() : "");
		defaultNormalExportTF.setEnabled(false);
		defaultNormalExportBrowseBtn = new JButton("Browse...");

		defaultSuperheroicExportLbl = new JLabel(
				"Default Superheroic Export Format:");
		defaultSuperheroicExportTF = new JTextField(
				HeroDesigner.getInstance().getPrefs()
						.getDefaultSuperheroicFormatPath() != null ? HeroDesigner
						.getInstance().getPrefs()
						.getDefaultSuperheroicFormatPath()
						: "");
		defaultSuperheroicExportTF.setEnabled(false);
		defaultSuperheroicExportBrowseBtn = new JButton("Browse...");

		defaultVehicleExportLbl = new JLabel("Default Vehicle Export Format:");
		defaultVehicleExportTF = new JTextField(
				HeroDesigner.getInstance().getPrefs()
						.getDefaultVehicleFormatPath() != null ? HeroDesigner
						.getInstance().getPrefs().getDefaultVehicleFormatPath()
						: "");
		defaultVehicleExportTF.setEnabled(false);
		defaultVehicleExportBrowseBtn = new JButton("Browse...");

		generalPanel = new JPanel(new GridBagLayout());
		systemPanel = new JPanel(new GridBagLayout());
		displayPanel = new JPanel(new GridBagLayout());

		doneBtn = new JButton("Done");

		templatePanel = new JPanel(new GridBagLayout());
	}

	private void layoutComponent() {
		GridBagConstraints gbc = new GridBagConstraints();

		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.insets = new Insets(5, 2, 2, 5);
		gbc.gridwidth = 2;

		// generalPanel.add(useWindowDecorationsCB, gbc);
		gbc.gridy++;
		generalPanel.add(restoreWindowCB, gbc);
		gbc.gridy++;
		generalPanel.add(rememberDialogCB, gbc);
		gbc.gridy++;
		generalPanel.add(loadCharactersCB, gbc);
		gbc.gridy++;
		gbc.weighty = 0;
		gbc.anchor = GridBagConstraints.NORTHWEST;
		generalPanel.add(loadPrefabsCB, gbc);
		gbc.gridy++;
		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.EAST;
		generalPanel.add(tabPlacementLbl, gbc);
		gbc.gridx = 1;
		gbc.weightx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		generalPanel.add(tabPlacementCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.weightx = 0;
		gbc.gridwidth = 2;
		gbc.anchor = GridBagConstraints.WEST;
		if (System.getProperties().getProperty("os.name").toUpperCase()
				.indexOf("WINDOWS") >= 0) {
			generalPanel.add(memoryLbl, gbc);
			gbc.gridx = 0;
			gbc.gridy++;
			gbc.weightx = 1;
			gbc.anchor = GridBagConstraints.WEST;
			gbc.fill = gbc.HORIZONTAL;
			generalPanel.add(memorySlider, gbc);
		}

		gbc.gridx = 0;
		gbc.weighty = 1;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.gridy++;
		generalPanel.add(new JPanel(), gbc);

		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 1;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;

		displayPanel.add(useWGCB, gbc);
		gbc.gridy++;
		displayPanel.add(flagForcedModifiersCB, gbc);
		gbc.gridy++;
		displayPanel.add(metricCB, gbc);
		gbc.gridy++;
		displayPanel.add(displayActivePointsCB, gbc);
		gbc.gridy++;
		displayPanel.add(showCommonLimitationsCB, gbc);
		gbc.gridy++;
		displayPanel.add(useAbbreviationsCB, gbc);
		gbc.gridy++;
		displayPanel.add(showPopupDefinitionsCB, gbc);
		gbc.gridy++;
		gbc.weighty = 1;
		displayPanel.add(new JPanel(), gbc);

		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;

		gbc.gridwidth = 3;
		systemPanel.add(confirmDeleteCB, gbc);
		gbc.gridy++;
		systemPanel.add(warnOnMultipleCB, gbc);
		gbc.gridy++;
		systemPanel.add(useQuickAssignCB, gbc);
		gbc.gridy++;
		systemPanel.add(promptForImageExportCB, gbc);

		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridy++;
		gbc.gridwidth = 1;
		gbc.weightx = 0;
		systemPanel.add(browserPathLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(browserPathBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(browserPathTF, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;

		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridy++;
		gbc.fill = GridBagConstraints.NONE;
		gbc.weightx = 0;
		systemPanel.add(refreshTemplateOnRestoreLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		gbc.gridwidth = 2;
		systemPanel.add(refreshTemplateOnRestoreCB, gbc);

		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.weightx = 0;
		systemPanel.add(refreshRulesOnRestoreLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		gbc.gridwidth = 2;
		systemPanel.add(refreshRulesOnRestoreCB, gbc);

		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.weightx = 0;
		systemPanel.add(numberDigitsLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 1;
		gbc.gridwidth = 2;
		systemPanel.add(numberDigitsTF, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.gridy++;
		gbc.gridwidth = 1;
		gbc.weightx = 0;
		systemPanel.add(templateDirLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(templateBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(templateDirTF, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridy++;
		gbc.weightx = 0;
		systemPanel.add(defaultRulesDirLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(defaultRulesDirBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(defaultRulesDirTF, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridy++;
		gbc.weightx = 0;
		systemPanel.add(defaultExportDirLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(defaultExportDirBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(defaultExportDirTF, gbc);

		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridy++;
		gbc.weightx = 0;
		systemPanel.add(defaultAIExportLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(defaultAIExportBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(defaultAIExportTF, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridy++;
		gbc.weightx = 0;
		systemPanel.add(defaultAutomatonExportLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(defaultAutomatonExportBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(defaultAutomatonExportTF, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridy++;
		gbc.weightx = 0;
		systemPanel.add(defaultBaseExportLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(defaultBaseExportBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(defaultBaseExportTF, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridy++;
		gbc.weightx = 0;
		systemPanel.add(defaultComputerExportLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(defaultComputerExportBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(defaultComputerExportTF, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridy++;
		gbc.weightx = 0;
		systemPanel.add(defaultHeroicExportLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(defaultHeroicExportBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(defaultHeroicExportTF, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridy++;
		gbc.weightx = 0;
		systemPanel.add(defaultNormalExportLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(defaultNormalExportBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(defaultNormalExportTF, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridy++;
		gbc.weightx = 0;
		systemPanel.add(defaultSuperheroicExportLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(defaultSuperheroicExportBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(defaultSuperheroicExportTF, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridy++;
		gbc.weightx = 0;
		systemPanel.add(defaultVehicleExportLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		systemPanel.add(defaultVehicleExportBrowseBtn, gbc);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 2;
		gbc.weightx = 1;
		systemPanel.add(defaultVehicleExportTF, gbc);

		gbc.gridx = 0;
		gbc.gridwidth = 3;
		gbc.gridy++;
		gbc.weighty = 1;
		gbc.weightx = 0;
		systemPanel.add(new JPanel(), gbc);

		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 1;
		gbc.weighty = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;

		modifierIntelligencePanel.add(modifierIntelligenceCB, gbc);
		gbc.gridy++;
		modifierIntelligencePanel.add(checkModsDuringEditCB, gbc);
		gbc.gridy++;
		modifierIntelligencePanel.add(removeIllegalModsCB, gbc);
		gbc.gridy++;
		gbc.weighty = 1;
		modifierIntelligencePanel.add(new JPanel(), gbc);

		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;

		tabPane.addTab("General", new JScrollPane(generalPanel));
		tabPane.addTab("System", new JScrollPane(systemPanel));
		tabPane.addTab("Display", new JScrollPane(displayPanel));
		tabPane.addTab("Modifier Intelligence", new JScrollPane(
				modifierIntelligencePanel));

		GridBagConstraints g = new GridBagConstraints();
		g.gridx = 0;
		g.gridy = 0;
		g.fill = GridBagConstraints.NONE;
		g.anchor = GridBagConstraints.WEST;
		g.weightx = 1;
		g.weighty = 0;
		g.insets = new Insets(3, 3, 3, 3);
		JPanel prefabs = new JPanel(new GridBagLayout());
		Collections.sort(GenericObject.getAllSources());

		prefabs.add(showPowersPrefabsOnEquipmentCB, g);
		g.gridy++;
		prefabs.add(showEquipmentPrefabsOnPowersCB, g);
		g.anchor = GridBagConstraints.NORTHWEST;
		g.fill = GridBagConstraints.BOTH;
		g.gridy++;
		g.weightx = 1;
		g.weighty = 1;
		prefabs.add(new JPanel(), g);

		tabPane.add("Prefabs", new JScrollPane(prefabs));

		if (!HeroDesigner.getActiveTemplate().is6E()) {
			g = new GridBagConstraints();
			g.gridx = 0;
			g.gridy = 0;
			g.fill = GridBagConstraints.NONE;
			g.anchor = GridBagConstraints.WEST;
			g.weightx = 1;
			g.weighty = 0;
			g.insets = new Insets(3, 3, 3, 3);
			JPanel sources = new JPanel(new GridBagLayout());
			Collections.sort(GenericObject.getAllSources());
			for (int i = 0; i < GenericObject.getAllSources().size(); i++) {
				SourceCheckBox check = new SourceCheckBox(GenericObject
						.getAllSources().get(i).toString());
				sources.add(check, g);
				g.gridy++;
			}
			g.anchor = GridBagConstraints.NORTHWEST;
			g.fill = GridBagConstraints.HORIZONTAL;
			templatePanel.add(sources, g);
			g.weightx = 1;
			g.weighty = 1;
			templatePanel.add(new JPanel(), g);
			sources
					.setBorder(BorderFactory
							.createTitledBorder("Allowed Source Books (5th Edition Rules only)"));
			tabPane.add("Template", new JScrollPane(templatePanel));
		}

		JPanel content = new JPanel(new BorderLayout());
		content.add(new JScrollPane(tabPane), "Center");

		JPanel buttons = new JPanel(new FlowLayout(FlowLayout.CENTER));
		buttons.add(doneBtn);

		content.add(buttons, "South");
		setContentPane(content);
	}
}